$(function () {
    $("#view").on("click", ".edit", function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var id = $(this).attr("data-id");
        $.ajax({
            type: "POST",
            url: "/view-edit-member",
            dataType: "JSON",
            data: {
                id: id,
                _token: token,
            },
            success: function (data) {
                $("#editdata").modal("show");
                $("#idm").val(id);
                $("#kode").val(data.kode);
                $("#nama").val(data.nama);
                $("#hp").val(data.hp);
                $("#email").val(data.email);
                $("#username").val(data.username);
                if (data.kelamin_member == "L") {
                    $("#kelamin").val("L");
                    $("#laki").prop("checked", true);
                } else {
                    $("#kelamin").val("P");
                    $("#perempuan").prop("checked", true);
                }
            },
        });
    });

    $("#editdata").on("click", ".jns", function () {
        var isi = $(this).val();
        $("#kelamin").val(isi);
    });

    $(".simpan_data").click(function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var id = $("#idm").val();
        var nm_member = $("#nama").val();
        var hp_member = $("#hp").val();
        var email_member = $("#email").val();
        var username = $("#username").val();
        var kelamin = $("#kelamin").val();

        var password = 1;

        if (nm_member == "") {
            $("#nama").focus();
        } else if (hp_member == "") {
            $("#hp").focus();
        } else if (email_member == "") {
            $("#email").focus();
        } else if (username == "") {
            $("#username").focus();
        } else {
            $.ajax({
                type: "POST",
                url: "/update-member",
                data: {
                    id: id,
                    password: password,
                    nm_member: nm_member,
                    hp_member: hp_member,
                    email_member: email_member,
                    kelamin: kelamin,
                    username: username,
                    _token: token,
                },
                success: function (data) {
                    Swal.fire({
                        icon: "success",
                        title: "Berhasil",
                        text: "Edit Member berhasil disimpan!",
                    }).then((result) => {
                        if (result.isConfirmed) {
                            document.location.href = "";
                        }
                    });
                },
            });
        }
    });

    $("#view").on("click", ".ongkir", function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var id = $(this).attr("data-id");
        var baru = "lama";
        $.ajax({
            type: "POST",
            url: "/view-edit-ongkir",
            data: {
                id: id,
                baru: baru,
                _token: token,
            },
            success: function (data) {
                $("#editongkir").modal("show");
                $("#vdataongkir").html(data);
            },
        });
    });

    $("#vdataongkir").on("change", ".cariongkir", function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var id = $(this).val();
        $.ajax({
            type: "POST",
            url: "/view-ongkir",
            dataType: "JSON",
            data: {
                id: id,
                _token: token,
            },
            success: function (data) {
                $("#rute").val(data.alamat);
                $("#berat").val(data.berat);
                $("#harga").val(data.harga);
            },
        });
    });

    $("#vdataongkir").on("click", ".terapkan", function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var id = $(this).attr("data-id");
        var alamat = $("#alamat").val();
        var sts_alamat = $("#sts_alamat").val();
        var ido = $("#ongkir").val();
        $.ajax({
            type: "POST",
            url: "/update-ongkir-member",
            data: {
                id: id,
                ido: ido,
                alamat: alamat,
                sts_alamat: sts_alamat,
                _token: token,
            },
            beforeSend: function () {
                $("#terap").html(
                    '<i class="fas fa-spinner fa-spin"></i> Tunggu..'
                );
                $("#terap").attr("disabled", true);
            },
            success: function (data) {
                $("#terap").html(' <i class="fa fa-check mr-2"></i> Terapkan');
                $("#terap").attr("disabled", false);

                Swal.fire({
                    icon: "success",
                    title: "Berhasil",
                    text: "Edit Ongkir Member berhasil diterapkan!",
                });
            },
        });
    });

    $("#view").on("click", ".password", function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var id = $(this).attr("data-id");
        $.ajax({
            type: "POST",
            url: "/view-edit-member",
            dataType: "JSON",
            data: {
                id: id,
                _token: token,
            },
            success: function (data) {
                $("#editpass").modal("show");
                $("#idmp").val(id);
                $("#kodep").val(data.kode);
                $("#namap").val(data.nama);
            },
        });
    });

    $(".simpan_password").click(function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var id = $("#idmp").val();
        var password = $("#password").val();

        if (password == "") {
            $("#password").focus();
        } else {
            $.ajax({
                type: "POST",
                url: "/update-member",
                data: {
                    id: id,
                    password: password,
                    _token: token,
                },
                success: function (data) {
                    Swal.fire({
                        icon: "success",
                        title: "Berhasil",
                        text: "Edit Password Member berhasil disimpan!",
                    }).then((result) => {
                        if (result.isConfirmed) {
                            document.location.href = "";
                        }
                    });
                },
            });
        }
    });

    $("#view").on("click", ".detail", function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var id = $(this).attr("data-id");
        $.ajax({
            type: "POST",
            url: "/view-detail-member",
            data: {
                id: id,
                _token: token,
            },
            success: function (data) {
                $("#detail").modal("show");
                $("#vdetail").html(data);
            },
        });
    });

    // ceklis
    $("#cekall").change(function () {
        if ($(this).prop("checked")) {
            $(".ceklis").prop("checked", true);
        } else {
            $(".ceklis").prop("checked", false);
        }
    });

    $("#pilih_hapus").click(function () {
        var allVals = [];
        $(".ceklis:checked").each(function () {
            allVals.push($(this).val());
        });
        var token = $("meta[name='csrf-token']").attr("content");

        if (allVals.length <= 0) {
            Toast.fire({
                icon: "error",
                title: "Ceklis data yang akan dihapus!!!.",
            });
        } else {
            Swal.fire({
                title: "Pastikan dengan benar!",
                text: "Data yang anda pilih akan dihapus!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Ya, Hapus!",
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: "deleteall-member",
                        data: {
                            allVals: allVals,
                            _token: token,
                        },
                        beforeSend: function () {
                            $("#pilih_hapus").html(
                                '<i class="fas fa-spinner fa-spin"></i> Tunggu..'
                            );
                            $("#pilih_hapus").attr("disabled", true);
                        },
                        success: function (data) {
                            // alert(data)
                            $("#pilih_hapus").html(
                                '<i class="fa fa-trash"></i>'
                            );
                            $("#pilih_hapus").attr("disabled", true);
                            Swal.fire({
                                icon: "success",
                                title: "Berhasil",
                                text: "Data berhasil dihapus!",
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    document.location.href = "";
                                }
                            });
                        },
                    });
                }
            });
        }
    });

    $("#cetak_kartu").click(function () {
        var allVals = [];
        $(".ceklis:checked").each(function () {
            allVals.push($(this).val());
        });
        var token = $("meta[name='csrf-token']").attr("content");

        if (allVals.length <= 0) {
            Toast.fire({
                icon: "error",
                title: "Ceklis data yang akan dicetak!!!.",
            });
        } else {
            $.ajax({
                type: "POST",
                url: "cetak-kartu",
                data: {
                    allVals: allVals,
                    _token: token,
                },
                beforeSend: function () {
                    $("#cetak_kartu").html(
                        '<i class="fas fa-spinner fa-spin"></i> Tunggu..'
                    );
                    $("#cetak_kartu").attr("disabled", true);
                },
                success: function (data) {
                    $(".tampil_data").html(data);
                    $("#hidedata").hide();

                    $("#cetak_kartu").html(
                        '<i class="fa fa-print"> Cetak Kartu </i>'
                    );
                    $("#cetak_kartu").attr("disabled", false);

                    let timerInterval;
                    Swal.fire({
                        title: "Mohon tunggu sebentar!",
                        html: "Proses mempersiapkan data <b></b> milliseconds.",
                        timer: 2000,
                        timerProgressBar: true,
                        didOpen: () => {
                            Swal.showLoading();
                            const timer = Swal.getPopup().querySelector("b");
                            timerInterval = setInterval(() => {
                                timer.textContent = `${Swal.getTimerLeft()}`;
                            }, 100);
                        },
                        willClose: () => {
                            clearInterval(timerInterval);
                        },
                    }).then((result) => {
                        /* Read more about handling dismissals below */
                        if (result.dismiss === Swal.DismissReason.timer) {
                            printPageArea("print");
                            document.location.href = "";
                        }
                    });
                },
            });
        }
    });

    function printPageArea(areaID) {
        var printContent = document.getElementById(areaID).innerHTML;
        var originalContent = document.body.innerHTML;
        document.body.innerHTML = printContent;
        window.print();
        document.body.innerHTML = originalContent;
    }
});
